import java.awt.Color;

import acm.graphics.*;
public class KarelDisplay extends GCanvas {
	private KarelWorld world;
	
	public void setWorld(KarelWorld world) {
		this.world = world;
	}
	
	public void update() {
		removeAll();
		
		drawCorners();
		drawKarel();
	}
	
	private void drawCorners() {
		for (int row = 0; row < world.numRows(); row++) {
			for (int col = 0; col < world.numCols(); col++) {
				drawSingleCorner(row, col);
			}
		}
	}
	
	private void drawSingleCorner(int row, int col) {
		double squareSize = Math.min((double)getWidth() / world.numCols(),
				                     (double)getHeight() / world.numRows());
		
		double x = col * squareSize;
		double y = (world.numRows() - 1 - row) * squareSize;
		
		drawCenteredPoint(x + squareSize / 2, y + squareSize / 2);
	}
	
	private void drawCenteredPoint(double x, double y) {
		GRect point = new GRect(x - 1, y - 1, 2, 2);
		point.setFilled(true);
		point.setColor(Color.GRAY);
		add(point);
	}
	
	private void drawKarel() {
		GImage karelImage = new GImage("Karel" + world.getKarel().getDirection() + ".png");
		
		double squareSize = Math.min((double)getWidth() / world.numCols(),
                                     (double)getHeight() / world.numRows());
		double x = world.getKarel().getColumn() * squareSize;
		double y = (world.numRows() - 1 - world.getKarel().getRow()) * squareSize;
		
		karelImage.setSize(squareSize, squareSize);
		add(karelImage, x, y);
	}
}
